export declare function setEnv(newEnv: Record<string, string>): void;
/** Static env mock - to be used inside `vi.mock` */
export declare function mockEnv(options?: {
    env?: Record<string, string>;
    withDefaults?: boolean;
}): Promise<{
    readonly default: Record<string, any>;
}>;
/** Dynamic env mock */
export declare function doMockEnv(options?: {
    env?: Record<string, string>;
    withDefaults?: boolean;
}): {
    env: {
        [x: string]: string;
    };
    setEnv: (newEnv: Record<string, string>) => void;
};
