import { Readable } from 'node:stream';
import { Plural } from '@directus/types';

declare function isIn<T extends readonly string[]>(value: string, array: T): value is T[number];
declare function isTypeIn<T extends {
    type?: string;
}, E extends string>(object: T, array: readonly E[]): object is Extract<T, {
    type?: E;
}>;

declare const isReadableStream: (input: any) => input is Readable;

declare function listFolders(location: string): Promise<string[]>;

declare function pathToRelativeUrl(filePath: string, root?: string): string;

declare function pluralize<T extends string>(str: T): Plural<T>;
declare function depluralize<T extends string>(str: Plural<T>): T;

declare const readableStreamToString: (stream: Readable) => Promise<string>;

declare function resolvePackage(name: string, root?: string): string;

declare function createTmpFile(): Promise<{
    path: string;
    cleanup: () => Promise<void>;
}>;

export { createTmpFile, depluralize, isIn, isReadableStream, isTypeIn, listFolders, pathToRelativeUrl, pluralize, readableStreamToString, resolvePackage };
