import type { GraphQLFieldConfigArgumentMap, GraphQLArgumentConfig, GraphQLOutputType, GraphQLFieldConfig, GraphQLInputType, GraphQLResolveInfo, GraphQLFieldResolver } from './graphql';
import { ObjectTypeComposer } from './ObjectTypeComposer';
import type { ObjectTypeComposerArgumentConfigMap, ObjectTypeComposerArgumentConfigMapDefinition, ObjectTypeComposerArgumentConfig, ObjectTypeComposerArgumentConfigDefinition, ObjectTypeComposerArgumentConfigAsObjectDefinition } from './ObjectTypeComposer';
import { InputTypeComposer } from './InputTypeComposer';
import { SchemaComposer } from './SchemaComposer';
import type { ProjectionType } from './utils/projection';
import { TypeInPath } from './utils/typeByPath';
import type { ComposeOutputType, ComposeOutputTypeDefinition, ComposeNamedOutputType, ComposeNamedInputType, ComposeInputTypeDefinition } from './utils/typeHelpers';
import type { Thunk, ThunkWithSchemaComposer, Extensions, Directive } from './utils/definitions';
export declare type ResolverKinds = 'query' | 'mutation' | 'subscription';
export declare type ResolverDefinition<TSource, TContext, TArgs = any> = {
    type?: ThunkWithSchemaComposer<Readonly<ComposeOutputType<TContext>> | ComposeOutputTypeDefinition<TContext> | Readonly<Resolver<any, TContext, any>>, SchemaComposer<TContext>>;
    resolve?: ResolverRpCb<TSource, TContext, TArgs>;
    args?: ObjectTypeComposerArgumentConfigMapDefinition<TArgs>;
    name?: string;
    displayName?: string;
    kind?: ResolverKinds;
    description?: string;
    deprecationReason?: string | null;
    projection?: ProjectionType;
    parent?: Resolver<any, TContext, any>;
    extensions?: Extensions;
    directives?: Directive[];
};
export declare type ResolverResolveParams<TSource, TContext, TArgs = any> = {
    source: TSource;
    args: TArgs;
    context: TContext;
    info: GraphQLResolveInfo;
    projection: Partial<ProjectionType>;
    [opt: string]: any;
};
export declare type ResolverFilterArgFn<TSource, TContext, TArgs = any> = (query: any, value: any, resolveParams: ResolverResolveParams<TSource, TContext, TArgs>) => any;
export declare type ResolverFilterArgConfigDefinition<TSource, TContext, TArgs = any> = {
    name: string;
    type: ComposeInputTypeDefinition;
    description?: string | null | void;
    query?: ResolverFilterArgFn<TSource, TContext, TArgs>;
    filterTypeNameFallback?: string;
    defaultValue?: any;
};
export declare type ResolverSortArgFn<TSource, TContext, TArgs = any> = (resolveParams: ResolverResolveParams<TSource, TContext, TArgs>) => any;
export declare type ResolverSortArgConfig<TSource, TContext, TArgs = any> = {
    name: string;
    sortTypeNameFallback?: string;
    value: {
        [key: string]: any;
    } | ResolverSortArgFn<TSource, TContext, TArgs> | string | number | boolean | any[];
    deprecationReason?: string | null;
    description?: string | null;
};
export declare type ResolverWrapCb<TNewSource, TPrevSource, TContext, TNewArgs = any, TPrevArgs = any> = (newResolver: Resolver<TNewSource, TContext, TNewArgs>, prevResolver: Resolver<TPrevSource, TContext, TPrevArgs>) => Resolver<TNewSource, TContext, TNewArgs>;
export declare type ResolverRpCb<TSource, TContext, TArgs = any> = (resolveParams: ResolverResolveParams<TSource, TContext, TArgs>) => Promise<any> | any;
export declare type ResolverRpCbPartial<TSource, TContext, TArgs = any> = (resolveParams: Partial<ResolverResolveParams<TSource, TContext, TArgs>>) => Promise<any> | any;
export declare type ResolverNextRpCb<TSource, TContext, TArgs = any> = (next: ResolverRpCb<TSource, TContext, TArgs>) => ResolverRpCb<TSource, TContext, TArgs>;
export declare type ResolverDebugOpts = {
    showHidden?: boolean;
    depth?: number;
    colors?: boolean;
};
export declare type ResolverMiddleware<TSource, TContext, TArgs = any> = (resolve: (source: TSource, args: TArgs, context: TContext, info: GraphQLResolveInfo) => any, source: TSource, args: TArgs, context: TContext, info: GraphQLResolveInfo) => any;
export declare class Resolver<TSource = any, TContext = any, TArgs = any, TReturn = any> {
    schemaComposer: SchemaComposer<TContext>;
    type: ComposeOutputType<TContext>;
    args: ObjectTypeComposerArgumentConfigMap<any>;
    name: string;
    displayName: string | undefined;
    kind: ResolverKinds | undefined;
    description: string | undefined;
    deprecationReason: string | null | undefined;
    projection: ProjectionType;
    parent: Resolver<TSource, TContext, any> | undefined;
    extensions: Extensions | undefined;
    directives: Directive[] | undefined;
    resolve: ResolverRpCbPartial<TSource, TContext, TArgs>;
    constructor(opts: ResolverDefinition<TSource, TContext, TArgs>, schemaComposer: SchemaComposer<TContext>);
    getType(): GraphQLOutputType;
    getTypeName(): string;
    getTypeComposer(): ComposeNamedOutputType<TContext>;
    getOTC(): ObjectTypeComposer<TReturn, TContext>;
    setType<TNewReturn>(typeDef: ThunkWithSchemaComposer<Readonly<ComposeOutputType<TContext>> | ComposeOutputTypeDefinition<TContext> | Readonly<Resolver<any, TContext, any>>, SchemaComposer<TContext>>): Resolver<TSource, TContext, TArgs, TNewReturn>;
    hasArg(argName: string): boolean;
    getArg(argName: string): ObjectTypeComposerArgumentConfig;
    getArgConfig(argName: string): GraphQLArgumentConfig;
    getArgType(argName: string): GraphQLInputType;
    getArgTypeName(fieldName: string): string;
    getArgs(): ObjectTypeComposerArgumentConfigMap<TArgs>;
    getArgNames(): string[];
    setArgs<TNewArgs>(args: ObjectTypeComposerArgumentConfigMapDefinition<TNewArgs>): Resolver<TSource, TContext, TNewArgs>;
    setArg(argName: string, argConfig: ObjectTypeComposerArgumentConfigDefinition): this;
    setArgType(argName: string, typeDef: Thunk<ComposeInputTypeDefinition>): this;
    extendArg(argName: string, partialArgConfig: Partial<ObjectTypeComposerArgumentConfigAsObjectDefinition>): this;
    addArgs(newArgs: ObjectTypeComposerArgumentConfigMapDefinition<any>): this;
    removeArg(argNameOrArray: string | string[]): this;
    removeOtherArgs(argNameOrArray: string | string[]): this;
    reorderArgs(names: string[]): this;
    getArgTC(argName: string): ComposeNamedInputType<TContext>;
    getArgITC(argName: string): InputTypeComposer<TContext>;
    isArgNonNull(argName: string): boolean;
    makeArgNonNull(argNameOrArray: string | string[]): this;
    makeRequired(argNameOrArray: string | string[]): this;
    makeArgNullable(argNameOrArray: string | string[]): this;
    makeOptional(argNameOrArray: string | string[]): this;
    isArgPlural(argName: string): boolean;
    makeArgPlural(argNameOrArray: string | string[]): this;
    makeArgNonPlural(argNameOrArray: string | string[]): this;
    cloneArg(argName: string, newTypeName: string): this;
    addFilterArg(opts: ResolverFilterArgConfigDefinition<TSource, TContext, TArgs>): this;
    addSortArg(opts: ResolverSortArgConfig<TSource, TContext, TArgs>): this;
    getResolve(): ResolverRpCb<TSource, TContext, TArgs>;
    setResolve(resolve: ResolverRpCb<TSource, TContext, TArgs>): this;
    withMiddlewares(middlewares: Array<ResolverMiddleware<TSource, TContext, TArgs>>): Resolver<TSource, TContext, TArgs>;
    wrap<TNewSource, TNewArgs>(cb?: ResolverWrapCb<TNewSource, TSource, TContext, TNewArgs, TArgs> | null, newResolverOpts?: Partial<ResolverDefinition<TNewSource, TContext, TNewArgs>>): Resolver<TNewSource, TContext, TNewArgs>;
    wrapResolve(cb: ResolverNextRpCb<TSource, TContext, TArgs>, wrapperName?: string): Resolver<TSource, TContext, TArgs>;
    wrapArgs<TNewArgs>(cb: (prevArgs: GraphQLFieldConfigArgumentMap) => ObjectTypeComposerArgumentConfigMapDefinition<TArgs>, wrapperName?: string): Resolver<TSource, TContext, TNewArgs>;
    wrapCloneArg(argName: string, newTypeName: string): Resolver<TSource, TContext, TArgs>;
    wrapType(cb: (prevType: ComposeOutputType<TContext>) => ComposeOutputTypeDefinition<TContext>, wrapperName?: string): Resolver<TSource, TContext, TArgs>;
    getFieldConfig(opts?: {
        projection?: ProjectionType;
    }): GraphQLFieldConfig<TSource, TContext, TArgs>;
    getFieldResolver(opts?: {
        projection?: ProjectionType;
    }): GraphQLFieldResolver<TSource, TContext, TArgs>;
    getKind(): ResolverKinds | void;
    setKind(kind: string): this;
    getDescription(): string | undefined;
    setDescription(description: string | undefined): this;
    getDeprecationReason(): string | undefined | null;
    setDeprecationReason(reason: string | undefined): this;
    get(path: string | string[]): TypeInPath<TContext> | void;
    clone<TNewSource, TNewArgs>(opts?: Partial<ResolverDefinition<TNewSource, TContext, TNewArgs>>): Resolver<TNewSource, TContext, TNewArgs>;
    cloneTo(anotherSchemaComposer: SchemaComposer<any>, cloneMap?: Map<any, any>): Resolver<any, any, any>;
    getExtensions(): Extensions;
    setExtensions(extensions: Extensions): this;
    extendExtensions(extensions: Extensions): this;
    clearExtensions(): this;
    getExtension(extensionName: string): unknown;
    hasExtension(extensionName: string): boolean;
    setExtension(extensionName: string, value: unknown): this;
    removeExtension(extensionName: string): this;
    getNestedName(): string;
    toString(): string;
    setDisplayName(name: string): this;
    toDebugStructure(): Record<string, any>;
    debugExecTime(): Resolver<TSource, TContext, TArgs>;
    debugParams(filterPaths?: string | string[] | undefined | null, opts?: ResolverDebugOpts): Resolver<TSource, TContext, TArgs>;
    debugPayload(filterPaths?: string | string[] | undefined | null, opts?: ResolverDebugOpts): Resolver<TSource, TContext, TArgs>;
    debug(filterDotPaths?: {
        params?: string | string[] | undefined | null;
        payload?: string | string[] | undefined | null;
    }, opts?: ResolverDebugOpts): Resolver<TSource, TContext, TArgs>;
}
//# sourceMappingURL=Resolver.d.ts.map